#include<stdio.h>
#include<linux/landlock.h>
#include<sys/syscall.h>
#include<fcntl.h>
#include<sys/fcntl.h>
#include<sys/stat.h>
#include<unistd.h>
#include<sys/prctl.h>

#ifndef O_PATH
#define O_PATH 010000000
#endif

const char* path = "/tmp";

int main(int argc, char* argv[])
{
	if (argc < 2)
	{
		printf("Usage: %s <file>\n", argv[0]);
		return 1;
	}

	// General ruleset
	struct landlock_ruleset_attr ruleset_attr = {
		.handled_access_fs =
			LANDLOCK_ACCESS_FS_EXECUTE |
			LANDLOCK_ACCESS_FS_WRITE_FILE |
			LANDLOCK_ACCESS_FS_READ_FILE |
			LANDLOCK_ACCESS_FS_READ_DIR |
			LANDLOCK_ACCESS_FS_REMOVE_DIR |
			LANDLOCK_ACCESS_FS_REMOVE_FILE |
			LANDLOCK_ACCESS_FS_MAKE_CHAR |
			LANDLOCK_ACCESS_FS_MAKE_DIR |
			LANDLOCK_ACCESS_FS_MAKE_REG |
			LANDLOCK_ACCESS_FS_MAKE_SOCK |
			LANDLOCK_ACCESS_FS_MAKE_FIFO |
			LANDLOCK_ACCESS_FS_MAKE_BLOCK |
			LANDLOCK_ACCESS_FS_MAKE_SYM,
	};

	int ruleset = syscall(SYS_landlock_create_ruleset, &ruleset_attr, sizeof(ruleset_attr), 0);

	// /tmp read only ruleset
	struct landlock_path_beneath_attr attr = {
		.allowed_access =
			LANDLOCK_ACCESS_FS_READ_FILE,
		.parent_fd = open(path, O_PATH | O_CLOEXEC)
	};

	syscall(SYS_landlock_add_rule, ruleset, LANDLOCK_RULE_PATH_BENEATH, &attr, 0);
	
	// Apply landlock
	prctl(PR_SET_NO_NEW_PRIVS, 1, 0, 0, 0);
	syscall(SYS_landlock_restrict_self, ruleset, 0);
	close(ruleset);

	// Read file and write to output
	FILE* file = fopen(argv[1], "r");
	char buffer[64];
	fread(buffer, 1, 64, file);
	fclose(file);

	printf("%s\n", buffer);
	return 0;
}
