#include <stdio.h>
#include <unistd.h>
#include <sys/syscall.h>
#include <linux/seccomp.h>
#include <seccomp.h>

int main()
{
	scmp_filter_ctx ctx = seccomp_init(SCMP_ACT_KILL);
	
	seccomp_rule_add(ctx, SCMP_ACT_ALLOW, SCMP_SYS(exit), 0);
	seccomp_rule_add(ctx, SCMP_ACT_ALLOW, SCMP_SYS(exit_group), 0);
	seccomp_rule_add(ctx, SCMP_ACT_ALLOW, SCMP_SYS(brk), 0);
	//seccomp_rule_add(ctx, SCMP_ACT_ALLOW, SCMP_SYS(write), 2,
	//		SCMP_A0(SCMP_CMP_EQ, 1),
	//		SCMP_A2(SCMP_CMP_LE, 64)
	//);
	seccomp_rule_add(ctx, SCMP_ACT_ALLOW, SCMP_SYS(write), 2,
			SCMP_A0(SCMP_CMP_EQ, 1),
			SCMP_A1(SCMP_CMP_EQ, (long) "Hello, World!\n")
	);

	seccomp_load(ctx);
	seccomp_release(ctx);

	write(1, "Hello, World!\n", 14);
	write(1, "Hello, Woooooooooooooooooooooooooooooorld!\n", 43);
	write(1, "Hello, Woooooooooooooooooooooooooooooooooooooooooooooooooooooooooooorld!\n", 73);

	//printf("Hello, World!\n");

	return 0;
}
